# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 6
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # Initial move: Cooperate
    
    opponent_code_lower = opponent_program_code.lower()
    
    # Check for deterministic opponent strategies
    if "always cooperate" in opponent_code_lower or "return 'c'" in opponent_code_lower:
        return "D"  # Exploit always-cooperate
    if "always defect" in opponent_code_lower or "return 'd'" in opponent_code_lower:
        return "C"  # Minimize losses against always-defect
    
    # Probing defect in round 3
    if len(my_history) == 2:
        return "D"
    
    # Grim trigger if opponent defected first
    if "D" in opp_history and all(m == "C" for m in my_history[:opp_history.index("D")]):
        return "D"
    
    # Tit-for-tat after initial cooperation
    if len(opp_history) > 0:
        if opp_history[-1] == "D":
            return "D"
        else:
            return "C"
    
    # Default to cooperate if no other conditions met
    return "C"